/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.mc6809;

import frc.emul.api.IMemory;
import frc.emul.mc6809.Instruction;
import frc.emul.mc6809.Mode;
import frc.emul.mc6809.Operand;
import frc.emul.util.Utils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Instructions {
    private Map<String, Method> methods;
    private final Instruction[] P0;
    private final Instruction[] P1;
    private final Instruction[] P2;
    private final boolean undoc;
    private final Class simul;
    private static final Class[] METHODS_PARAM_TYPES = new Class[0];

    public Instructions(boolean bl) {
        this(null, bl);
    }

    public Instructions(Class clazz, boolean bl) {
        this.simul = clazz;
        this.undoc = bl;
        this.P0 = new Instruction[256];
        this.P1 = new Instruction[256];
        this.P2 = new Instruction[256];
        this.initPages();
    }

    public final Instruction fetch(IMemory iMemory, int n) {
        int n2 = iMemory.readU8(n);
        switch (n2) {
            case 16: {
                return this.P1[iMemory.readU8(n + 1)];
            }
            case 17: {
                return this.P2[iMemory.readU8(n + 1)];
            }
        }
        return this.P0[n2];
    }

    public final Instruction fetch(int n, int n2) {
        if (16 == n) {
            return this.P1[0xFF & n2];
        }
        if (17 == n) {
            return this.P2[0xFF & n2];
        }
        return this.P0[0xFF & n];
    }

    public final Instruction fetchPage0(int n) {
        return this.P0[0xFF & n];
    }

    public final Instruction fetchPage1(int n) {
        return this.P1[0xFF & n];
    }

    public final Instruction fetchPage2(int n) {
        return this.P2[0xFF & n];
    }

    public final Instruction[] getPage(int n) {
        switch (n) {
            case 0: {
                return this.P0;
            }
            case 1: {
                return this.P1;
            }
            case 2: {
                return this.P2;
            }
        }
        throw new IndexOutOfBoundsException("Page #" + n + " asked!");
    }

    private final void initPages() {
        this.methods = new HashMap<String, Method>(64);
        if (this.undoc) {
            this.newUndoc(2, "NEGCOM", 6, Mode.DIRECT, Operand.MEMORY);
            this.newUndoc(5, "LSR", 6, Mode.DIRECT, Operand.MEMORY);
            this.newUndoc(11, "DEC", 6, Mode.DIRECT, Operand.MEMORY);
            this.newUndoc(62, "RESET", 0, Mode.IMPLIED, Operand.NONE);
            this.newUndoc(65, "NEG", 2, Mode.IMPLIED, Operand.REG_A);
            this.newUndoc(66, "COM", 2, Mode.IMPLIED, Operand.REG_A);
            this.newUndoc(69, "LSR", 2, Mode.IMPLIED, Operand.REG_A);
            this.newUndoc(75, "DEC", 2, Mode.IMPLIED, Operand.REG_A);
            this.newUndoc(78, "CLR", 2, Mode.IMPLIED, Operand.REG_A);
            this.newUndoc(81, "NEG", 2, Mode.IMPLIED, Operand.REG_B);
            this.newUndoc(82, "COM", 2, Mode.IMPLIED, Operand.REG_B);
            this.newUndoc(85, "LSR", 2, Mode.IMPLIED, Operand.REG_B);
            this.newUndoc(91, "DEC", 2, Mode.IMPLIED, Operand.REG_B);
            this.newUndoc(94, "CLR", 2, Mode.IMPLIED, Operand.REG_B);
            this.newUndoc(97, "NEG", 6, Mode.INDEXED, Operand.MEMORY);
            this.newUndoc(98, "COM", 6, Mode.INDEXED, Operand.MEMORY);
            this.newUndoc(101, "LSR", 6, Mode.INDEXED, Operand.MEMORY);
            this.newUndoc(107, "DEC", 6, Mode.INDEXED, Operand.MEMORY);
            this.newUndoc(113, "NEG", 7, Mode.EXTENDED, Operand.MEMORY);
            this.newUndoc(114, "COM", 7, Mode.EXTENDED, Operand.MEMORY);
            this.newUndoc(117, "LSR", 7, Mode.EXTENDED, Operand.MEMORY);
            this.newUndoc(123, "DEC", 7, Mode.EXTENDED, Operand.MEMORY);
        }
        this.newInst(58, "ABX", 3, Mode.IMPLIED, Operand.NONE);
        this.newGroup(137, "ADC", 2, Operand.REG_A);
        this.newGroup(201, "ADC", 2, Operand.REG_B);
        this.newGroup(139, "ADD", 2, Operand.REG_A);
        this.newGroup(203, "ADD", 2, Operand.REG_B);
        this.newGroup(195, "ADD", 4, Operand.REG_D);
        this.newInst(28, "AND", 3, Mode.IMMEDIATE, Operand.REG_CC);
        this.newGroup(132, "AND", 2, Operand.REG_A);
        this.newGroup(196, "AND", 2, Operand.REG_B);
        this.newGroup(7, "ASR");
        this.newGroup(133, "BIT", 2, Operand.REG_A);
        this.newGroup(197, "BIT", 2, Operand.REG_B);
        this.newInst(32, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BRA");
        this.newInst(22, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBRA");
        this.newInst(33, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BRN");
        this.newInst(4129, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBRN");
        this.newInst(34, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BHI");
        this.newInst(4130, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBHI");
        this.newInst(35, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BLS");
        this.newInst(4131, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBLS");
        this.newInst(36, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BCC");
        this.newInst(4132, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBCC");
        this.newInst(37, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BCS");
        this.newInst(4133, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBCS");
        this.newInst(38, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BNE");
        this.newInst(4134, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBNE");
        this.newInst(39, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BEQ");
        this.newInst(4135, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBEQ");
        this.newInst(40, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BVC");
        this.newInst(4136, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBVC");
        this.newInst(41, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BVS");
        this.newInst(4137, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBVS");
        this.newInst(42, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BPL");
        this.newInst(4138, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBPL");
        this.newInst(43, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BMI");
        this.newInst(4139, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBMI");
        this.newInst(44, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BGE");
        this.newInst(4140, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBGE");
        this.newInst(45, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BLT");
        this.newInst(4141, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBLT");
        this.newInst(46, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BGT");
        this.newInst(4142, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBGT");
        this.newInst(47, "Bxx", 3, Mode.RELATIVE8, Operand.REG_PC, "BLE");
        this.newInst(4143, "Bxx", 5, Mode.RELATIVE16, Operand.REG_PC, "LBLE");
        this.newInst(141, "BSR", 7, Mode.RELATIVE8, Operand.REG_PC);
        this.newInst(23, "BSR", 9, Mode.RELATIVE16, Operand.REG_PC, "LBSR");
        this.newGroup(129, "CMP", 2, Operand.REG_A);
        this.newGroup(193, "CMP", 2, Operand.REG_B);
        this.newGroup(4227, "CMP", 5, Operand.REG_D);
        this.newGroup(4492, "CMP", 5, Operand.REG_S);
        this.newGroup(4483, "CMP", 5, Operand.REG_U);
        this.newGroup(140, "CMP", 4, Operand.REG_X);
        this.newGroup(4236, "CMP", 5, Operand.REG_Y);
        this.newGroup(15, "CLR");
        this.newGroup(3, "COM");
        this.newInst(60, "CWAI", 20, Mode.IMMEDIATE, Operand.REG_CC, "CWAI");
        this.newInst(25, "DAA", 2, Mode.IMPLIED, Operand.NONE);
        this.newGroup(10, "DEC");
        this.newGroup(136, "EOR", 2, Operand.REG_A);
        this.newGroup(200, "EOR", 2, Operand.REG_B);
        this.newInst(30, "EXG", 7, Mode.IMPLIED, Operand.REGISTER);
        this.newGroup(12, "INC");
        this.newInst(14, "JMP", 3, Mode.DIRECT, Operand.MEMORY);
        this.newInst(126, "JMP", 4, Mode.EXTENDED, Operand.MEMORY);
        this.newInst(110, "JMP", 3, Mode.INDEXED, Operand.MEMORY);
        this.newInst(157, "JSR", 7, Mode.DIRECT, Operand.MEMORY);
        this.newInst(189, "JSR", 8, Mode.EXTENDED, Operand.MEMORY);
        this.newInst(173, "JSR", 7, Mode.INDEXED, Operand.MEMORY);
        this.newGroup(134, "LD", 2, Operand.REG_A);
        this.newGroup(198, "LD", 2, Operand.REG_B);
        this.newGroup(204, "LD", 3, Operand.REG_D);
        this.newGroup(4302, "LD", 4, Operand.REG_S);
        this.newGroup(206, "LD", 3, Operand.REG_U);
        this.newGroup(142, "LD", 3, Operand.REG_X);
        this.newGroup(4238, "LD", 4, Operand.REG_Y);
        this.newInst(50, "LEA", 4, Mode.INDEXED, Operand.REG_S);
        this.newInst(51, "LEA", 4, Mode.INDEXED, Operand.REG_U);
        this.newInst(48, "LEA", 4, Mode.INDEXED, Operand.REG_X);
        this.newInst(49, "LEA", 4, Mode.INDEXED, Operand.REG_Y);
        this.newGroup(8, "LSL");
        this.newGroup(4, "LSR");
        this.newInst(61, "MUL", 11, Mode.IMPLIED, Operand.NONE);
        this.newInst(18, "NOP", 2, Mode.IMPLIED, Operand.NONE);
        this.newGroup(0, "NEG");
        this.newInst(26, "OR", 3, Mode.IMMEDIATE, Operand.REG_CC);
        this.newGroup(138, "OR", 2, Operand.REG_A);
        this.newGroup(202, "OR", 2, Operand.REG_B);
        this.newInst(52, "PSH", 5, Mode.IMPLIED, Operand.REG_S);
        this.newInst(54, "PSH", 5, Mode.IMPLIED, Operand.REG_U);
        this.newInst(53, "PUL", 5, Mode.IMPLIED, Operand.REG_S);
        this.newInst(55, "PUL", 5, Mode.IMPLIED, Operand.REG_U);
        this.newGroup(9, "ROL");
        this.newGroup(6, "ROR");
        this.newInst(57, "RTS", 5, Mode.IMPLIED, Operand.NONE);
        this.newInst(59, "RTI", 15, Mode.IMPLIED, Operand.NONE);
        this.newGroup(130, "SBC", 2, Operand.REG_A);
        this.newGroup(194, "SBC", 2, Operand.REG_B);
        this.newInst(29, "SEX", 2, Mode.IMPLIED, Operand.NONE);
        this.newStore(151, "ST", 4, Operand.REG_A);
        this.newStore(215, "ST", 4, Operand.REG_B);
        this.newStore(221, "ST", 5, Operand.REG_D);
        this.newStore(4319, "ST", 6, Operand.REG_S);
        this.newStore(223, "ST", 5, Operand.REG_U);
        this.newStore(159, "ST", 5, Operand.REG_X);
        this.newStore(4255, "ST", 6, Operand.REG_Y);
        this.newGroup(128, "SUB", 2, Operand.REG_A);
        this.newGroup(192, "SUB", 2, Operand.REG_B);
        this.newGroup(131, "SUB", 4, Operand.REG_D);
        this.newInst(63, "SWI", 19, Mode.IMPLIED, Operand.NONE);
        this.newInst(4159, "SWIx", 20, Mode.IMPLIED, Operand.NONE, "SWI2");
        this.newInst(4415, "SWIx", 20, Mode.IMPLIED, Operand.NONE, "SWI3");
        this.newInst(19, "SYNC", 2, Mode.IMPLIED, Operand.NONE);
        this.newInst(31, "TFR", 6, Mode.IMPLIED, Operand.REGISTER);
        this.newGroup(13, "TST");
        this.methods = null;
    }

    private final void newGroup(int n, String string, int n2, Operand operand) {
        this.newInst(n, string, null, n2, Mode.IMMEDIATE, operand, true);
        this.newInst(n + 16, string, null, n2 + 2, Mode.DIRECT, operand, true);
        this.newInst(n + 32, string, null, n2 + 2, Mode.INDEXED, operand, true);
        this.newInst(n + 48, string, null, n2 + 3, Mode.EXTENDED, operand, true);
    }

    private final void newStore(int n, String string, int n2, Operand operand) {
        this.newInst(n, string, null, n2, Mode.DIRECT, operand, true);
        this.newInst(n + 16, string, null, n2, Mode.INDEXED, operand, true);
        this.newInst(n + 32, string, null, n2 + 1, Mode.EXTENDED, operand, true);
    }

    private final void newGroup(int n, String string) {
        this.newInst(n, string, null, 6, Mode.DIRECT, Operand.MEMORY, true);
        this.newInst(n + 64, string, null, 2, Mode.IMPLIED, Operand.REG_A, true);
        this.newInst(n + 80, string, null, 2, Mode.IMPLIED, Operand.REG_B, true);
        this.newInst(n + 96, string, null, 6, Mode.INDEXED, Operand.MEMORY, true);
        this.newInst(n + 112, string, null, 7, Mode.EXTENDED, Operand.MEMORY, true);
    }

    private final Instruction newInst(int n, String string, int n2, Mode mode, Operand operand) {
        return this.newInst(n, string, null, n2, mode, operand, true);
    }

    private final Instruction newInst(int n, String string, int n2, Mode mode, Operand operand, String string2) {
        return this.newInst(n, string, string2, n2, mode, operand, true);
    }

    private final Instruction newUndoc(int n, String string, int n2, Mode mode, Operand operand) {
        return this.newInst(n, string, null, n2, mode, operand, false);
    }

    private final Instruction newInst(int n, String string, String string2, int n2, Mode mode, Operand operand, boolean bl) {
        Instruction[] instructionArray;
        Object object;
        Method method = this.methods.get(string);
        if (method == null && this.simul != null) {
            object = "_" + string;
            try {
                method = this.simul.getMethod((String)object, METHODS_PARAM_TYPES);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new RuntimeException("Failed to lookup the instruction execution method \"" + (String)object + "\"", noSuchMethodException);
            }
            this.methods.put(string, method);
        }
        if (string2 == null) {
            string2 = string;
            switch (operand) {
                case REG_A: {
                    string2 = String.valueOf(string2) + "A";
                    break;
                }
                case REG_B: {
                    string2 = String.valueOf(string2) + "B";
                    break;
                }
                case REG_D: {
                    string2 = String.valueOf(string2) + "D";
                    break;
                }
                case REG_X: {
                    string2 = String.valueOf(string2) + "X";
                    break;
                }
                case REG_Y: {
                    string2 = String.valueOf(string2) + "Y";
                    break;
                }
                case REG_U: {
                    string2 = String.valueOf(string2) + "U";
                    break;
                }
                case REG_S: {
                    string2 = String.valueOf(string2) + "S";
                    break;
                }
                case REG_CC: {
                    string2 = String.valueOf(string2) + "CC";
                }
            }
        }
        object = new Instruction(n, string2, mode, operand, n2, bl, method);
        int n3 = n & 0xFF;
        switch (n & 0xFF00) {
            case 0: {
                instructionArray = this.P0;
                break;
            }
            case 4096: {
                instructionArray = this.P1;
                break;
            }
            case 4352: {
                instructionArray = this.P2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid opcode 0x" + Utils.hex(2, n) + " (" + string2 + ")");
            }
        }
        if (instructionArray[n3] != null) {
            throw new IllegalArgumentException("Opcode 0x" + Utils.hex(2, n) + " (" + string2 + ") is already defined for " + instructionArray[n3].getName());
        }
        instructionArray[n3] = object;
        return object;
    }
}

